#!/bin/sh

echo 'LOAD_DATA: Starting'

### set oracle files
echo 'LOAD_DATA: Set Oracle files'
su -l oracle -c "cp /vagrant/oracle/sqlnet.ora /u01/app/oracle/product/11.2.0/dbhome_1/network/admin/."

# create directories
if [ ! -d "/data" ]; then
	mkdir /data
fi

if [ ! -d "/data/tde_wallet" ]; then
	mkdir /data/tde_wallet
fi

if [ ! -d "/data/tde_wallet/mhv" ]; then
	mkdir /data/tde_wallet/mhv
fi

if [ ! -d "/data/setup" ]; then
	mkdir /data/setup
fi

if [ ! -d "/data/logs" ]; then
	mkdir /data/logs
fi

chown oracle:oinstall -R /data
	  
su -l oracle -c "cp /vagrant/oracle/tde_wallet/cwallet.sso /data/tde_wallet/mhv/"
su -l oracle -c "cp /vagrant/oracle/tde_wallet/ewallet.p12 /data/tde_wallet/mhv/"

### get latest dump file if not found
echo 'LOAD_DATA: Get dump file...could take a long time if not found'
dumpFile="/installs/mhvsyst_latest.dmp"
if [ ! -f "$dumpFile" ]
then
    su -l oracle -c "/usr/bin/wget --timestamping --directory-prefix=/data/setup --no-check-certificate --no-verbose http://DNS/tools/db/mhvsyst_latest.dmp"
else
    su -l oracle -c "cp /installs/mhvsyst_latest.dmp /data/setup/."
fi

### create directory and tablespaces
echo 'LOAD_DATA: Create UNIX_DIR Oracle directory and tablespaces'
su -l oracle -c "sqlplus / as sysdba <<EOF 
    @/vagrant/sql/mhvdata/mhvdata_prepare.sql; 
EOF" 

### load the data
echo 'LOAD_DATA: Load MHV data'
su -l oracle -c "cp /vagrant/oracle/mhv-import.par /data/setup/"
sed -i.bak "s/DEVID/${MHV_DB_ID}/g" /data/setup/mhv-import.par
su -l oracle -c "impdp system/MhvD4t4@ORCL PARFILE=/data/setup/mhv-import.par" 

### remove the dump file
echo 'LOAD_DATA: Remove dump file'
/bin/rm -rf /data/setup/mhvsyst_latest.dmp

### create directory and tablespaces
echo 'LOAD_DATA: Alter passwords'
su -l oracle -c "sqlplus / as sysdba <<EOF 
    @/vagrant/sql/mhvdata/mhvdata_alteruserpasswords.sql; 
EOF" 

### create directory and tablespaces
#echo 'LOAD_DATA: Create missing tables'
#su -l oracle -c "sqlplus / as sysdba <<EOF 
#    @/vagrant/sql/mhvdata/create_missing_tables.sql; 
#EOF" 

echo 'LOAD_DATA: Installation complete'
